import { ReactNode } from "react";
import { SidebarInset, SidebarProvider, SidebarRail } from "../ui/sidebar";
import { ApplicationSidebar } from "./application.sidebar";
import { cn } from "@/lib/utils";
import { ApplicationHeader } from "./application.header";

function INTERNAL__getNode(node: ReactNode, defaultNode: ReactNode) {
  if (node === null) {
    return null;
  }

  return node ?? defaultNode
}

export function ApplicationShell({
  children,
  className
}: {
  className?: string,
  children: {
    header?: ReactNode,
    content?: ReactNode,
    sidebar?: ReactNode,
  }
}) {
  const {
    sidebar,
    header,
    content,
  } = children

  return (
    <SidebarProvider>
      {INTERNAL__getNode(sidebar, <ApplicationSidebar />)}

      <SidebarInset>
        {INTERNAL__getNode(header, <ApplicationHeader />)}

        <div className={cn("flex flex-1 flex-col gap-4 p-4", className)}>
          {content}
        </div>

        <SidebarRail className="cursor-ew-resize" />
      </SidebarInset>
    </SidebarProvider>
  )
}
